/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.algorithm.IAlgorithm;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerDataWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.MultiStyleStringWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class TrainerListWidget
extends TrainerDataWidget {
    public static final int UPDATES_PER_TICK = 100;
    public static final int ENTRIES_PER_PAGE = 100;
    public static final int OBFUSCATION_INTERVAL_TICKS = 30;
    private int innerHeight;
    private int entryHeight;
    private List<String> trainerIds;
    private boolean showUndefeated;
    private boolean showAllTypes = true;
    private TrainerType trainerType = TrainerType.DEFAULT;
    private Map<Integer, List<Entry>> pages = new HashMap<Integer, List<Entry>>();
    private TrainerClickedConsumer trainerClickedHandler;
    private UpdateState updateState;
    private int page;
    private int maxPage;
    private Entry hovered;
    private Entry selected;
    private int ticks;

    public TrainerListWidget(int x, int y, int w, int h, class_327 font, List<String> trainerIds) {
        super(x, y, w, h, font);
        this.entryHeight = this.method_25364() / 8;
        this.setTrainerIds(trainerIds);
    }

    public void setTrainerIds(Collection<String> trainerIds) {
        this.trainerIds = List.copyOf(trainerIds);
        this.pages = new HashMap<Integer, List<Entry>>();
        this.updateState = new UpdateState(this.pages);
        this.updateInnerHeight();
        this.method_44382(0.0);
    }

    public int size() {
        return this.pages.values().stream().map(p -> p.size()).reduce(0, (s1, s2) -> s1 + s2);
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getMaxPage() {
        return this.maxPage;
    }

    @Override
    public void setPage(int page) {
        int nextPage = Math.max(0, Math.min(this.maxPage, page));
        if (nextPage != this.page) {
            this.page = nextPage;
            this.updateInnerHeight();
            this.method_44382(0.0);
        }
    }

    public boolean getShowUndefeated() {
        return this.showUndefeated;
    }

    public TrainerType getTrainerType() {
        return this.trainerType;
    }

    public boolean getShowAllTypes() {
        return this.showAllTypes;
    }

    public void setShowUndefeated(boolean showUndefeated) {
        if (this.showUndefeated != showUndefeated) {
            this.showUndefeated = showUndefeated;
            this.updateEntries();
        }
    }

    public void setTrainerType(TrainerType trainerType) {
        if (!this.trainerType.equals(trainerType)) {
            this.trainerType = trainerType;
            this.updateEntries();
        }
    }

    public void setShowAllTypes(boolean showAllTypes) {
        if (this.showAllTypes != showAllTypes) {
            this.showAllTypes = showAllTypes;
            this.updateEntries();
        }
    }

    public void setOnTrainerClicked(TrainerClickedConsumer trainerClickedHandler) {
        this.trainerClickedHandler = trainerClickedHandler;
    }

    public void tick() {
        if (this.updateState.finished()) {
            this.updateState = new UpdateState();
        } else {
            this.updateState.tick();
        }
        ++this.ticks;
    }

    @Override
    protected int method_44391() {
        return (int)((float)this.innerHeight * 0.65f);
    }

    private void updateInnerHeight() {
        this.innerHeight = Math.max(this.method_25364() - this.method_44385(), this.pages.getOrDefault(this.page, List.of()).size() * this.entryHeight);
    }

    @Override
    protected void renderPage(class_332 guiGraphics, int x, int y, float f) {
        this.hovered = null;
        for (Entry entry : this.pages.getOrDefault(this.page, List.of())) {
            entry.render(guiGraphics, x, y, f);
        }
        if (this.hovered != this.selected) {
            this.selected = this.hovered;
        }
    }

    public boolean method_25402(double x, double y, int i) {
        if (super.method_25402(x, y, i)) {
            if (this.trainerClickedHandler != null && this.selected != null) {
                this.trainerClickedHandler.accept(this.selected.trainerNr, this.selected.trainerId, this.selected.state);
            }
            return true;
        }
        return false;
    }

    private void updateEntries() {
        this.pages.clear();
        this.maxPage = 0;
        this.page = 0;
        this.updateState = new UpdateState(this.pages);
        this.updateInnerHeight();
        this.method_44382(0.0);
    }

    private class UpdateState
    implements IAlgorithm {
        public final Map<Integer, List<Entry>> pages;
        public final PlayerState playerState;
        public int i;
        public int c;
        public int x;
        public int y;
        public int w;
        public int h;
        public TrainerManager tdm;
        private boolean realtime;

        public UpdateState() {
            this(new HashMap<Integer, List<Entry>>());
        }

        private UpdateState(Map<Integer, List<Entry>> pages) {
            class_310 mc = class_310.method_1551();
            this.realtime = pages == TrainerListWidget.this.pages;
            this.pages = pages;
            this.playerState = PlayerState.get((class_1657)mc.field_1724);
            this.tdm = RCTMod.getInstance().getTrainerManager();
            this.w = (int)((float)(TrainerListWidget.this.method_25368() - TrainerListWidget.this.method_44385()) / 0.65f);
            this.h = TrainerListWidget.this.entryHeight;
        }

        @Override
        public void tick() {
            int p = 0;
            int r = 0;
            boolean hasUpdate = false;
            for (int u = 0; this.i < TrainerListWidget.this.trainerIds.size() && u < 100; ++u) {
                String trainerId = TrainerListWidget.this.trainerIds.get(this.i);
                TrainerMobData trMob = this.tdm.getData(trainerId);
                if (TrainerListWidget.this.showAllTypes || trMob.getType().equals(TrainerListWidget.this.trainerType)) {
                    int count = this.playerState.getTrainerDefeatCount(trainerId);
                    boolean isNextKeyTrainer = this.playerState.isKeyTrainer(trainerId);
                    if (TrainerListWidget.this.showUndefeated || isNextKeyTrainer || count > 0) {
                        p = this.c / 100;
                        r = this.c % 100;
                        this.y = r * this.h;
                        ++this.c;
                        this.pages.computeIfAbsent(p, ArrayList::new).add(this.createEntry(this.i + 1, trainerId, count > 0 ? (isNextKeyTrainer ? EntryState.DISCOVERED_KEY : EntryState.DISCOVERED) : (isNextKeyTrainer ? EntryState.HIDDEN_KEY : EntryState.UNKNOWN), trMob, count, isNextKeyTrainer));
                        hasUpdate = true;
                    }
                }
                ++this.i;
            }
            if (!this.realtime && this.finished()) {
                TrainerListWidget.this.pages = this.pages;
                TrainerListWidget.this.maxPage = p;
                TrainerListWidget.this.page = Math.max(0, Math.min(p, TrainerListWidget.this.page));
                TrainerListWidget.this.updateInnerHeight();
            } else if (this.realtime && hasUpdate) {
                TrainerListWidget.this.maxPage = p;
                TrainerListWidget.this.updateInnerHeight();
            }
        }

        @Override
        public boolean finished() {
            return this.i >= TrainerListWidget.this.trainerIds.size();
        }

        private Entry createEntry(int trainerNr, String trainerId, EntryState entryState, TrainerMobData trMob, int defeatCount, boolean isKeyTrainer) {
            String name = entryState != EntryState.UNKNOWN ? trMob.getTrainerTeam().getName() : "???";
            class_5250 nameComponent = TrainerDataWidget.toComponent(name);
            MultiStyleStringWidget numberWidget = new MultiStyleStringWidget(TrainerListWidget.this, this.x, this.y, this.w, this.h, (class_2561)TrainerDataWidget.toComponent(String.format("%04d: ", trainerNr)), TrainerListWidget.this.font).addStyle(class_2583.field_24360.method_10977(class_124.field_1061)).alignLeft();
            MultiStyleStringWidget nameWidget = new MultiStyleStringWidget(TrainerListWidget.this, (int)((double)this.x + (double)this.w * 0.18), this.y, (int)((double)this.w * 0.7), this.h, (class_2561)nameComponent, TrainerListWidget.this.font).addStyle(class_2583.field_24360.method_10977(class_124.field_1061)).addStyle(class_2583.field_24360.method_36141(Boolean.valueOf(true))).addStyle(class_2583.field_24360.method_10977(class_124.field_1061).method_36141(Boolean.valueOf(true))).scrolling().alignLeft();
            MultiStyleStringWidget countWidget = new MultiStyleStringWidget(TrainerListWidget.this, this.x, this.y, this.w, this.h, (class_2561)(defeatCount > 9000 ? TrainerDataWidget.toComponent(" >9k") : (defeatCount > 999 ? TrainerDataWidget.toComponent((defeatCount % 1000 != 0 ? " >" : " ") + defeatCount / 1000 + "k") : TrainerDataWidget.toComponent(" " + defeatCount))), TrainerListWidget.this.font).addStyle(class_2583.field_24360.method_10977(class_124.field_1061)).alignRight();
            return new Entry(trainerNr, trainerId, entryState, numberWidget, nameWidget, countWidget);
        }
    }

    public static interface TrainerClickedConsumer {
        public void accept(int var1, String var2, EntryState var3);
    }

    private class Entry {
        public final EntryState state;
        public final int trainerNr;
        public final String trainerId;
        public final MultiStyleStringWidget number;
        public final MultiStyleStringWidget name;
        public final MultiStyleStringWidget count;
        private boolean isObfuscated;
        private int currentTicks;

        public Entry(int trainerNr, String trainerId, EntryState state, MultiStyleStringWidget number, MultiStyleStringWidget name, MultiStyleStringWidget count) {
            this.state = state;
            this.trainerNr = trainerNr;
            this.trainerId = trainerId;
            this.number = number;
            this.name = name;
            this.count = count;
            this.isObfuscated = state == EntryState.DISCOVERED_KEY || state == EntryState.HIDDEN_KEY;
        }

        public void render(class_332 guiGraphics, int x, int y, float f) {
            if (this.state == EntryState.DISCOVERED_KEY && TrainerListWidget.this.ticks != this.currentTicks && TrainerListWidget.this.ticks % 30 == 0) {
                this.isObfuscated = !this.isObfuscated;
                this.currentTicks = TrainerListWidget.this.ticks;
            }
            if (this.isMouseOver(TrainerListWidget.this.localX(x), TrainerListWidget.this.localY(y))) {
                this.number.setStyle(1);
                this.name.setStyle(this.isObfuscated ? 3 : 1);
                this.count.setStyle(1);
                TrainerListWidget.this.hovered = this;
            } else {
                this.number.setStyle(0);
                this.name.setStyle(this.isObfuscated ? 2 : 0);
                this.count.setStyle(0);
            }
            this.number.method_25394(guiGraphics, x, y, f);
            this.name.method_25394(guiGraphics, x, y, f);
            this.count.method_25394(guiGraphics, x, y, f);
        }

        public boolean isMouseOver(double localX, double localY) {
            return this.number.method_25405(localX, localY) || this.name.method_25405(localX, localY) || this.count.method_25405(localX, localY);
        }
    }

    public static enum EntryState {
        UNKNOWN,
        HIDDEN_KEY,
        DISCOVERED,
        DISCOVERED_KEY;

    }
}

